<?php

namespace App\Models;

use App\Models\Rooms;
use Illuminate\Database\Eloquent\Model;
use App\Console\Commands\GenerateMonthlyInvoices;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        // Other attributes...
        'room_id',
        'payments',
        'invoice_number',
        'id',
        'total_amount',
        'amount_paid',
        'payment_status',
        'created_at',
        'updated_at',
        'client_name',
        'payment_method',
        'due_date',
        'balance',

    ];

    public function rooms()
    {
        return $this->belongsTo(Rooms::class, 'room_id', 'id');
    }
public function scopeForUser($query, $userId)
{
    return $query->where('user_id', $userId);
}

public function scopeForApartment($query, $apartmentId)
{
    return $query->whereHas('room', function ($subquery) use ($apartmentId) {
        $subquery->where('apartment_id', $apartmentId);
    });
}
public function getBalanceAttribute()
    {
        return $this->total_amount - $this->amount_paid;
    }
public function scopeForRoom($query, $roomId)
{
    return $query->where('room_id', $roomId);
}
public function user()
{
    return $this->belongsTo(User::class,'user_id','id');
}
public function scopeForMonth($query, $year, $month)
{
    return $query->whereYear('created_at', $year)
                 ->whereMonth('created_at', $month);
}

public function scopeWithPreviousBalances($query, $userId, $year, $month)
{
    return $query->forUser($userId)
        ->forMonth($year, $month)
        ->orderBy('due_date', 'asc')
        ->get();
}
// // Inside the Invoice model
//    protected static function booted()
// {
//     static::creating(function ($invoice) {
//         // Generate a unique invoice number
//         $apartmentInitials = $invoice->rooms->apartments->first()->pivot->apartment_name;
//         $latestInvoice = Invoice::orderByDesc('id')->first();
//         $latestInvoiceNumber = $latestInvoice ? intval(substr($latestInvoice->invoice_number, strlen($apartmentInitials))) : 0;
//         $invoice->invoice_number = $apartmentInitials . ($latestInvoiceNumber + 1);
//     });
// }

protected static function booted()
{
    static::creating(function ($invoice) {
        // Check if the invoice is related to a room
        if ($invoice->room_id) {
        // Define the current date and time for invoice generation
$invoiceDate = now();
        // Clone the $invoiceDate for each invoice
    $invoiceDateClone = clone $invoiceDate;
        // Generate a unique invoice number
        $apartmentInitials = $invoice->rooms->apartments->first()->pivot->apartment_name;
        $latestInvoice = Invoice::orderByDesc('id')->first();
        // $latestInvoiceNumber = $latestInvoice ? intval(substr($latestInvoice->invoice_number, strlen($apartmentInitials))) : 0;
        $latestInvoiceNumber = self::generateUniqueInvoiceNumber($apartmentInitials);
         // Remove spaces from apartment initials
         $apartmentInitials = str_replace(' ', '', $apartmentInitials);

        // $invoice->invoice_number = strtoupper($apartmentInitials) . ($latestInvoiceNumber + 1);
        $invoice->invoice_number = strtoupper($apartmentInitials) . self::generateUniqueInvoiceNumber($apartmentInitials);
        $invoice->due_date = $invoiceDateClone->addDays(10);
        }
        else {
            $invoiceDate = now();
        // Clone the $invoiceDate for each invoice
    $invoiceDateClone = clone $invoiceDate;
            // New logic for invoices not related to rooms
            $apartment = Apartments::findOrFail($invoice->apartment_id);
            // Generate a unique invoice number based on apartment initials
            $apartmentInitials = strtoupper(implode('', array_map('ucfirst', explode(' ', $apartment->name))));
            $latestInvoice = Invoice::where('apartment_id', $apartment->id)->orderByDesc('id')->first();
            $latestInvoiceNumber = self::generateUniqueInvoiceNumber($apartmentInitials);
            // Remove spaces from apartment initials
            $apartmentInitials = str_replace(' ', '', $apartmentInitials);

           // $invoice->invoice_number = strtoupper($apartmentInitials) . ($latestInvoiceNumber + 1);
           $invoice->invoice_number = strtoupper($apartmentInitials) . self::generateUniqueInvoiceNumber($apartmentInitials);
           $invoice->due_date = $invoiceDateClone->addDays(10);
        }
    });
}

protected static function generateUniqueInvoiceNumber($apartmentInitials, $attempt = 1)
{
    // Get the latest invoice with the given apartment initials
    $latestInvoice = Invoice::where('invoice_number', 'like', strtoupper($apartmentInitials) . '%')->orderByDesc('id')->first();

    // If no previous invoice, return 1
    if (!$latestInvoice) {
        return 1;
    }

    // Extract the numeric part of the invoice number
    preg_match('/\d+$/', $latestInvoice->invoice_number, $matches);
    $latestNumber = $matches ? intval($matches[0]) : 0;

    // Generate the next invoice number
    $nextNumber = $latestNumber + $attempt;

    // Check if the new invoice number already exists
    $existingInvoice = Invoice::where('invoice_number', strtoupper($apartmentInitials) . $nextNumber)->first();

    // If it exists, recursively try the next number
    if ($existingInvoice) {
        return self::generateUniqueInvoiceNumber($apartmentInitials, $attempt + 1);
    }

    return $nextNumber;
}

}
