<?php

namespace App\Models;

use App\Models\Apartments;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmailTemplate extends Model
{
    use HasFactory;
    protected $table = 'email_templates';

    //protected $table = 'apartment_email_template';
    protected $fillable = ['name', 'subject', 'body'];

    public function apartments()
    {
        return $this->belongsToMany(Apartments::class, 'apartment_email_template', 'email_template_id', 'apartment_id');
    }
}
