<?php

namespace App\Models;

use App\Models\User;
use App\Models\Rooms;
use App\Models\Service;
use App\Models\Landlord;
use App\Models\FixedExpense;
use App\Models\EmailTemplate;
use App\Models\VaryingExpense;
use Database\Factories\RoomsFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\ApartmentSMSConfiguration;
use App\Models\ApartmentSmtpConfiguration;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Apartments extends Model
{
    use HasFactory;
//     public function rooms()
// {
//     return $this->belongsToMany(Rooms::class, 'apartments_room')
//         ->withPivot('room_number', 'apartment_name');
// }
//protected $table = 'apartment_email_template';
protected $fillable = [
    'name',
    'capacity',
    'status',
    'country',
    'county',
    'district',
    'division',
    'location',
    'sub_location',
    'payment_methods',
    'billing_cycle',
    'currency',
    'active_theme',
    'features',
    'socials',
];

public function rooms()
{
    return $this->belongsToMany(Rooms::class, 'apartments_rooms', 'apartment_id', 'room_id')
    ->withPivot('room_number', 'apartment_name');
}
// public function landlords()
// {
//     return $this->belongsToMany(User::class, 'user_apartment', 'apartment_id', 'user_id')
//         ->where('role', 'landlord'); // Filter by the 'landlord' role
// }
public function getTotalRooms()
{
    return $this->rooms()->count();
}

public function landlords()
{
    return $this->belongsToMany(User::class, 'user_apartment','apartment_id', 'user_id')
        ->withPivot('role') // Include the pivot column
        ->wherePivot('role', 'landlord') // Set a default value
        ->withTimestamps();
}

public function caretaker()
{
    return $this->belongsToMany(Caretaker::class);
}

public function users()
{
    return $this->belongsToMany(User::class, 'user_apartment', 'apartment_id','user_id')
    ->withPivot('role');
}
public function invoices()
{
    return $this->hasManyThrough(Invoice::class, Rooms::class);
}

public function requests()
{
    return $this->hasMany(Request::class);
}
 // Define One-to-Many Relationship with Fixed Expenses
 public function fixedExpenses()
 {
     return $this->hasMany(FixedExpense::class,'apartment_id');
 }

 // Define One-to-Many Relationship with Varying Expenses
 public function varyingExpenses()
 {
     return $this->hasMany(VaryingExpense::class,'apartment_id');
 }
 public function licensePurchase()
    {
        return $this->belongsTo(LicensePurchase::class);
    }
    public function services()
    {
        return $this->belongsToMany(Service::class)->withPivot('id', 'subscription_date', 'next_billing_date');
    }
    public function watchlists()
    {
        return $this->morphMany(Watchlist::class, 'watchable');
    }

    public function emailTemplates()
    {
        return $this->belongsToMany(EmailTemplate::class,'apartment_email_template', 'email_template_id', 'apartment_id');
    }

    public function smtpConfiguration()
    {
        return $this->hasOne(ApartmentSmtpConfiguration::class);
    }

    public function smsConfiguration()
    {
        return $this->hasOne(ApartmentSMSConfiguration::class);
    }
    public function county()
    {
        return $this->belongsTo(County::class);
    }
}

