<?php

namespace App\Listeners;

use App\Events\UserUnassignedFromRoom;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class ChangeUserRoleToGuest
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function handle(UserUnassignedFromRoom $event)
    {
        $user = $event->user;

        // Check if the user has the "tenant" role
        if ($user->hasRole('tenant')) {
            // Remove the "tenant" role from the user
            $user->removeRole('tenant');
        }

        // Check if the user doesn't have any rooms assigned
        if ($user->rooms->isEmpty()) {
            // Assign the "guest" role to the user
            $user->assignRole('guest');
        }
    }
}
