<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckApartmentOwnership
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $user = auth()->user();
        $apartment = $request->route('apartment'); // Assuming you use route model binding.

        if ($user->hasRole('landlord') && $user->id === $apartment->landlord_id) {
            return $next($request);
        }

        if ($user->hasRole('caretaker') && $user->id === $apartment->caretaker_id) {
            return $next($request);
        }

        if ($user->apartments->contains($apartment)) {
            return $next($request);
        }

        abort(403, 'Access Denied');
    }
}
