<?php


namespace App\Http\Controllers;

use App\Models\userTask;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserTaskController extends Controller
{
    //
    public function index()
    {
        $tasks = Auth::user()->tasks;
        return view('landlord.dashboard', compact('tasks'));
    }

    public function store(Request $request)
{
    $request->validate([
        'text' => 'required|string|max:255',
        // Add other validation rules as needed
    ]);

    $user = Auth::user();
    $user->tasks()->create([
        'text' => $request->input('text'),
        // Add other columns as needed
    ]);

    // Additional processing if needed

    return redirect()->route('landlord-home');
}
    public function destroy(userTask $task)
    {
        if ($task->user_id == Auth::id()) {
            $task->delete();
        }
        return redirect()->route('tasks.index');
    }

    public function cancel(userTask $task)
    {
        if ($task->user_id == Auth::id()) {
            $task->update(['status' => 'canceled']);
        }
        return redirect()->route('tasks.index');
    }

    public function complete(userTask $task)
    {
        if ($task->user_id == Auth::id()) {
            $task->update(['status' => 'completed']);
        }
        return redirect()->route('tasks.index');
    }

}
