<?php

namespace App\Http\Controllers;

use App\Models\Rooms;
use App\Models\Invoice;
use App\Models\Payment;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Collection;

class TenantServiceController extends Controller
{
    //
    public function index()
{
    $apartment = Auth::user()->apartment; // Assuming the authenticated user is associated with an apartment
    // $services = $apartment->services;
    $user=Auth::user();
    $tenantServices = $user->services;
    $tenantRoom = $user->rooms;

     // Check if $services and $rooms are null, and if so, set them to an empty collection
     $tenantServices = $tenantServices ?? collect();
     $tenantRoom = $tenantRoom ?? collect();

    //  dd($tenantServices);

    return view('tenant.tenantServices', compact('user', 'tenantServices','tenantRoom', 'apartment'));
}

public function subscribe(Service $service)
{
    $apartment = Auth::user()->apartment; // Assuming the authenticated user is associated with an apartment

    // Subscribe to the service
    $apartment->services()->attach($service, [
        'subscription_date' => now(),
        'next_billing_date' => now()->addMonth(), // You can adjust this based on your billing logic
    ]);

    return redirect()->route('tenantservices.index')->with('success', 'Service subscribed successfully.');
}
public function showTransactions(){
    $user = Auth::user();

        // Retrieve the tenant's rooms
        $rooms = $user->rooms;
        // Assuming the authenticated user is associated with an apartment, retrieve it
        $apartment = $user->apartment;

        // Load user's invoices with associated rooms and transactions
// $invoices = Invoice::where('user_id', $user->id)->with('rooms', 'transactions')->get();
// Load user's invoices with associated rooms

    // Load user's invoices with associated transactions
    // $transactions = Payment::where('user_id', $user->id)->with('invoice')->get();

    $invoices = $user->invoices()->with('rooms')->get();
     // Retrieve transactions associated with the user
 // Initialize an empty array to store transactions
$transactions = [];

// Iterate through each invoice
foreach ($invoices as $invoice) {
    // Parse JSON data from the payments column
    $payments = json_decode($invoice->payments, true);

    // Check if payments exist
    if (is_array($payments)) {
        // Iterate through each payment in the invoice
        foreach ($payments as $payment) {
            // Format payment data and add it to the transactions array
            $transactions[] = [
                'invoice_number' => $invoice->invoice_number,
                'payment_date' => $payment['payment_date'],
                'payment_amount' => $payment['payment_amount'],
                'payment_method' => $payment['payment_method'],
                'transaction_id' => $payment['transaction_id'],
                'transaction_fee' => $payment['transaction_fee']
            ];
        }
    }
}

// Convert the transactions array to a collection
$transactions = new Collection($transactions);

    return view('tenant.transactions', compact('transactions', 'apartment'));
}
public function roomdetails($id)
{
    // Fetch the room details
    $room = Rooms::findOrFail($id);

    // Load related data such as occupants and invoices
    $occupants = $room->users;
    $invoices = $room->invoices;

    // Pass data to the view
    return view('tenant.room_details', compact('room', 'occupants', 'invoices'));
}
}
