<?php

namespace App\Http\Controllers;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TenantController extends Controller
{
    //
    public function index()
    {
        $user = Auth::user();

        // Retrieve the tenant's rooms
        $rooms = $user->rooms;

        // Load user's invoices with associated rooms
        $invoices = $user->invoices()->with('rooms')->get();

        // Retrieve the tenant's services
        $tenantServices = $user->services;

        // Retrieve the tenant's rooms
        $tenantRooms = $user->rooms;
        // Get the count of tenant's rooms
$roomCount = $tenantRooms->count();

        // Assuming the authenticated user is associated with an apartment, retrieve it
        $apartment = $user->apartment;

        // Retrieve the user's apartments
    $apartments = $user->apartments()->withPivot('role')->get();

   // Assuming $tenantRooms is a collection of Room models
if ($tenantRooms->isNotEmpty()) {
    // Get the first room from the collection
    $room = $tenantRooms->first();
    // Retrieve the associated apartments
    $apartments = $room->apartments;
    // Check if apartments exist for the room
    if ($apartments->isNotEmpty()) {
        // Get the first apartment from the collection
        $apartment = $apartments->first();
    } else {
        // Set $apartment to null if no apartments exist
        $apartment = null;
    }
} else {
    // Set $apartment to null if the user has no rooms
    $apartment = null;
}
        $allApartments = Apartments::all(); // Fetch all apartments
        // Retrieve apartments associated with the user or their rooms
    $apartments = $user->apartments()->orWhereHas('rooms', function ($query) use ($user) {
        $query->where('user_id', $user->id);
    })->get();
$apartmentInvoices=$invoices->count();
        return view('tenant.dashboard', compact('rooms', 'invoices', 'apartment', 'apartments', 'tenantRooms', 'tenantServices','allApartments','roomCount','apartmentInvoices'));
    }

    public function viewApartmentDetails($apartmentId)
{
    $apartment = Apartments::findOrFail($apartmentId);

    // Check if the authenticated user is a tenant of this apartment
    if (Auth::user()->isTenant() && Auth::user()->apartments->contains($apartment)) {
        return view('tenant.view_apartment_details', compact('apartment'));
    } else {
        abort(403, 'Unauthorized'); // Display a 403 Forbidden page if the user is not authorized
    }
}
public function selectApartment(Request $request)
{
    // Validate the request data
    $request->validate([
        'apartment_id' => 'required|exists:apartments,id',
    ]);

    // Redirect to the view for the selected apartment
    return redirect()->route('show.apartment', $request->apartment_id);
}


}
