<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\ApartmentLandlordViewController;

class SettingsController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function showGeneralSettings(request $request, $apartmentId){
        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
    $user = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];

        return view('landlord.apartments.settings.general-settings', compact('apartment'));
    }
    public function update(Request $request)
    {
        foreach ($request->all() as $key => $value) {
            Setting::where('key', $key)->update(['value' => $value]);
        }

        return redirect()->route('settings.index')->with('success', 'Settings updated successfully');
    }
    public function showExpensesSettings(request $request, $apartmentId){
        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
    $user = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];
        return view('landlord.apartments.settings.expenses-settings', compact('apartment'));
    }
    public function showPaymentGatewaySettings(request $request, $apartmentId){
        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
    $user = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];
        return view('landlord.apartments.settings.payment-gateways-settings', compact('apartment'));
    }


}
