<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\DB;

class RoleAssignmentController extends Controller
{
    //
    public function showRoleAssignmentForm()
    {
        $users = User::all();
        return view('admin.landlords', compact('users'));
    }

    public function assignRole(Request $request)
{
    $user = User::find($request->input('user_id'));
    $role = $request->input('role');

    // Assign the selected role to the user
    $user->assignRole($role);

    return redirect()->back()->with('success', 'Role assigned successfully');
}

public function assignLandlordRole()
{
    $users = DB::table('users')->get();
    $roles = DB::table('roles')->get();
    $landlords = User::role('landlord')->get();

    return view('admin.landlords', compact('users', 'roles','landlords'));
}
public function assignLandlordRoleToUser(Request $request)
{
    $request->validate([
        'user_id' => 'required',
        'role' => 'required',
    ]);

    $user = User::find($request->user_id);
// Assign the "landlord" role to the user
$user->assignRole('landlord');

return redirect()->back()->with('success', 'Landlord role assigned successfully.');

}
}
