<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use Illuminate\Http\Request;

class ReportsController extends Controller
{
    //
    public function monthlyReport()
{
    // Get the current year
    $currentYear = date('Y');

    // Initialize an array to store monthly reports
    $monthlyReports = [];

    // Loop through each month of the current year
    for ($month = 1; $month <= 12; $month++) {
        // Calculate the start and end dates for the current month
        $startDate = Carbon::createFromDate($currentYear, $month, 1)->startOfMonth();
        $endDate = $startDate->copy()->endOfMonth();

        // Query invoices with due dates in the current month
        $invoices = Invoice::whereBetween('due_date', [$startDate, $endDate])->get();

        // Calculate the total amount paid and unpaid for the current month
        $totalAmountPaid = $invoices->sum('paid_amount');
        $totalAmountUnpaid = $invoices->sum('total_amount') - $totalAmountPaid;

        // Create a monthly report entry
        $monthlyReport = [
            'month' => $startDate->format('F Y'), // Format as "Month Year"
            'total_amount_paid' => $totalAmountPaid,
            'total_amount_unpaid' => $totalAmountUnpaid,
        ];

        // Add the monthly report to the array
        $monthlyReports[] = $monthlyReport;
    }

    return view('admin/reports/monthly-report', compact('monthlyReports'));
}

public function thisMonthReport()
{
    // Get the current year and month
    $currentYear = now()->year;
    $currentMonth = now()->month;

    // Calculate the start and end dates for the current month
    $startDate = Carbon::create($currentYear, $currentMonth, 1)->startOfMonth();
    $endDate = Carbon::create($currentYear, $currentMonth, 1)->endOfMonth();

    // Query invoices with due dates in the current month
    $invoices = Invoice::whereBetween('due_date', [$startDate, $endDate])->get();

    // Update payment status to "Paid" if balance is zero
    foreach ($invoices as $invoice) {
        if ($invoice->balance == 0) {
            $invoice->payment_status = 'Paid';
        }
    }
    // Calculate the total amount paid and total amount unpaid for the current month
    $totalAmountPaid = $invoices->sum('paid_amount');
    $totalAmountUnpaid = $invoices->sum('total_amount') - $totalAmountPaid;

    // Create a monthly report entry
    $thisMonthReport = [
        'month' => $startDate->format('F Y'), // Format as "Month Year"
        'total_amount_paid' => $totalAmountPaid,
        'total_amount_unpaid' => $totalAmountUnpaid,
    ];
    // Calculate totals (if necessary)
    $totalInvoiceAmount = $invoices->sum('total_amount');
    $totalBalance = $invoices->sum('balance');
    $totalAmountPaid = $invoices->sum('amount_paid');
    $totalAmountUnpaid = $invoices->sum('amount_unpaid');
     // Fetch all users
     $users = User::with('invoices')->get();

     // Calculate compounded balances for each user
     $userCompoundedBalances = [];

     foreach ($users as $user) {
         $userCompoundedBalances[$user->id] = $this->calculateCompoundedBalances($user);
     }

     return view('admin/reports/this-month-report', compact('invoices', 'totalBalance', 'users', 'userCompoundedBalances', 'totalInvoiceAmount', 'totalAmountPaid', 'totalAmountUnpaid', 'thisMonthReport'));

}


private function calculateCompoundedBalances($user)
{
    $compoundedBalances = [];

    // Load invoices for the user with due dates in the current month
    $currentMonth = Carbon::now();
    $invoices = $user->invoices()->whereYear('due_date', $currentMonth->year)
        ->whereMonth('due_date', $currentMonth->month)
        ->get();

    foreach ($invoices as $invoice) {
        $roomBalance = 0;

        // Query previous invoices for the same room and earlier due dates
        $previousInvoices = $user->invoices()
            ->where('room_id', $invoice->room_id)
            ->where('due_date', '<', $invoice->due_date)
            ->orderBy('due_date', 'asc')
            ->get();

        // Calculate the compounded balance for this invoice
        $roomBalance = $invoice->balance;
        foreach ($previousInvoices as $previousInvoice) {
            $roomBalance += $previousInvoice->balance;
        }

        $compoundedBalances[] = [
            'invoice' => $invoice,
            'compounded_balance' => $roomBalance,
        ];
    }

    return $compoundedBalances;
}


}
