<?php

// OnlineAdminController.php
namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Ticket;
use Illuminate\Http\Request;

class OnlineAdminController extends Controller
{
    public function onlineadmins()
    {
        $openTicketCount = Ticket::where('status', 'open')->count();
        $onlineAdmins = User::where('is_admin', 1)
        ->where('is_online', true)
            ->select('name', 'avatar', 'updated_at')
            ->get();

        return view('admin/dashboard', compact('onlineAdmins' ,'openTicketCount', )); // Return the admin home view
    }
}
