<?php


namespace App\Http\Controllers;

use App\Mpesa\STKPush;
use App\Models\MpesaSTK;
use Iankumu\Mpesa\Facades\Mpesa;//import the Facade
use Illuminate\Http\Request;

class MpesaSTKPUSHController extends Controller
{
    public $result_code = 1;
    public $result_desc = 'An error occured';

    // Initiate  Stk Push Request
    public function STKPush(Request $request)
    {

           // Validate request data
    $request->validate([
        'amount' => 'required|numeric|min:10', // Minimum amount validation added
        'phone_number' => 'required|regex:/^254\d{9}$/',
    ]);

    // Retrieve data from the request
    $amount = $request->input('amount');
    $licenseType = $request->input('license_type');
    $userId = $request->input('user_id');
    $phoneNumber = $request->input('phone_number');

    // Check if phone number starts with '254'
    if (substr($phoneNumber, 0, 3) !== '254') {
        return redirect()->back()->with('error', 'Phone number should start with 254.');
    }


        $amount = $request->input('amount');
        $phoneno = $request->input('phonenumber');
        $account_number = $request->input('account_number');

        $response = Mpesa::stkpush($phoneno, $amount, $account_number);
        $result = json_decode((string)$response, true);

        MpesaSTK::create([
            'merchant_request_id' =>  $result['MerchantRequestID'],
            'checkout_request_id' =>  $result['CheckoutRequestID']
        ]);

        return $result;
    }

    // This function is used to review the response from Safaricom once a transaction is complete
    public function STKConfirm(Request $request)
    {
        $stk_push_confirm = (new STKPush())->confirm($request);

        if ($stk_push_confirm) {

            $this->result_code = 0;
            $this->result_desc = 'Success';
        }
        return response()->json([
            'ResultCode' => $this->result_code,
            'ResultDesc' => $this->result_desc
        ]);
    }
}
