<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\License;
use App\Models\User;
use Carbon\Carbon;

class LicenseController extends Controller
{
    // Regular user functions
    public function viewLicense(Request $request, $userId)
    {
        $user = User::findOrFail($userId);
        $license = $user->license;

        return view('user.view_license', compact('user', 'license'));
    }

    public function requestReissue(Request $request, $userId)
    {
        // Logic for requesting a reissue, send a notification or update status
        // ...

        return view('user.reissue_request_success');
    }

    public function installLicenseKey(Request $request, $userId)
    {
        // Logic for installing a license key, update status or perform necessary actions
        // ...

        return view('user.install_license_key_success');
    }

    // Admin functions
    public function createLicense(Request $request)
    {
        // Only allow admin to create licenses
        // Authentication and authorization checks for admin role

        // Validation logic for license creation request
        $request->validate([
            'user_id' => 'required',
            'type' => 'required|in:basic_tenant,premium_tenant,starter_landlord,professional_landlord,standard_landlord,lite_landlord,enterprise_landlord,executive_landlord',
            'expiry_interval' => 'required|in:monthly,quarterly,annually',
            // Add other necessary validations
        ]);

        $expiryDate = Carbon::now()->addMonths(1); // Default to one month, adjust as needed

        if ($request->expiry_interval === 'quarterly') {
            $expiryDate = Carbon::now()->addMonths(3);
        } elseif ($request->expiry_interval === 'annually') {
            $expiryDate = Carbon::now()->addYear();
        }

        $license = License::create([
            'user_id' => $request->user_id,
            'type' => $request->type,
            'expiry_date' => $expiryDate,
            // Add other fields as needed
        ]);

        // Additional logic for setting specific features based on the license type

        return view('admin.create_license_success');
    }

    public function cancelLicense(Request $request, $userId)
    {
        // Only allow admin to cancel licenses
        // Authentication and authorization checks for admin role

        // Logic for canceling a license, revoke access, or mark as inactive
        // ...

        return view('admin.cancel_license_success');
    }
}

// class LicenseController extends Controller
// {
//     public function createLicense(Request $request)
//     {
//         // Validation logic for license creation request
//         $request->validate([
//             'user_id' => 'required',
//             'type' => 'required|in:basic_tenant,premium_tenant,starter_landlord,professional_landlord,standard_landlord,lite_landlord,enterprise_landlord,executive_landlord',
//             'expiry_interval' => 'required|in:monthly,quarterly,annually',
//             // Add other necessary validations
//         ]);

//         $expiryDate = Carbon::now()->addMonths(1); // Default to one month, adjust as needed

//         if ($request->expiry_interval === 'quarterly') {
//             $expiryDate = Carbon::now()->addMonths(3);
//         } elseif ($request->expiry_interval === 'annually') {
//             $expiryDate = Carbon::now()->addYear();
//         }

//         $license = License::create([
//             'user_id' => $request->user_id,
//             'type' => $request->type,
//             'expiry_date' => $expiryDate,
//             // Add other fields as needed
//         ]);

//         // Additional logic for setting specific features based on the license type

//         return response()->json(['message' => 'License created successfully']);
//     }

//     public function viewLicense(Request $request, $userId)
//     {
//         $user = User::findOrFail($userId);
//         $license = $user->license;

//         return response()->json(['license' => $license]);
//     }

//     public function reissueLicense(Request $request, $userId)
//     {
//         // Logic for reissuing a license, update expiry date or other relevant details
//         // ...

//         return response()->json(['message' => 'License reissued successfully']);
//     }

//     public function upgradeLicense(Request $request, $userId)
//     {
//         // Logic for upgrading a license, update type, features, or other relevant details
//         // ...

//         return response()->json(['message' => 'License upgraded successfully']);
//     }

//     public function cancelLicense(Request $request, $userId)
//     {
//         // Logic for canceling a license, revoke access, or mark as inactive
//         // ...

//         return response()->json(['message' => 'License canceled successfully']);
//     }

//     // Example for creating a standard landlord license with specific limitations
//     public function createStandardLandlordLicense(Request $request)
//     {
//         // Validation logic for license creation request
//         $request->validate([
//             'user_id' => 'required',
//         ]);

//         // Check if the user is a landlord
//         $user = User::findOrFail($request->user_id);
//         if (!$user->isLandlord()) {
//             return response()->json(['error' => 'User is not a landlord'], 403);
//         }

//         // Check if the landlord already has a standard license
//         $existingLicense = $user->license;
//         if ($existingLicense && $existingLicense->type === 'standard_landlord') {
//             return response()->json(['error' => 'Landlord already has a standard license'], 403);
//         }

//         // Limitations for the standard landlord license
//         $maxApartments = 2;
//         $maxUsers = 100;

//         // Check if the landlord exceeds limitations
//         $apartmentCount = $user->apartments()->count();
//         $userCount = $user->tenants()->count();
//         if ($apartmentCount > $maxApartments || $userCount > $maxUsers) {
//             return response()->json(['error' => 'Landlord exceeds limitations for a standard license'], 403);
//         }

//         $expiryDate = Carbon::now()->addMonths(1); // Default to one month, adjust as needed

//         $license = License::create([
//             'user_id' => $request->user_id,
//             'type' => 'standard_landlord',
//             'expiry_date' => $expiryDate,
//             // Add other fields as needed
//         ]);

//         return response()->json(['message' => 'Standard landlord license created successfully']);
//     }
// } -->
