<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Booking;
use Illuminate\Http\Request;

class LandlordServiceController extends Controller
{
    //
    public function bookService(Request $request)
{
    $request->validate([
        'service_id' => 'required', // Assuming you have a field for service ID in the booking form
        'start_date' => 'required|date',
        'end_date' => 'required|date|after_or_equal:start_date',
    ]);

    // Calculate the duration of the booking period
    $startDate = Carbon::parse($request->start_date);
    $endDate = Carbon::parse($request->end_date);
    $duration = $startDate->diffInDays($endDate);

    // Create the booking record
    $booking = new Booking();
    $booking->user_id = auth()->id();
    $booking->bookable_id = $request->service_id;
    $booking->bookable_type = 'App\Models\Service';
    $booking->start_date = $startDate;
    $booking->end_date = $endDate;
    $booking->duration = $duration;
    $booking->status = 'pending'; // Set initial status
    $booking->save();

    // Return a response indicating success
    return response()->json(['message' => 'Service booked successfully', 'booking' => $booking]);
}
}
