<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Contracts\Session\Session;
use App\Http\Controllers\ApartmentLandlordViewController;

class LandlordPaymentController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function payments()
    {


        // Retrieve invoices for this month
        $invoicesThisMonth = Invoice::whereMonth('created_at', now()->month)->get();

        // Calculate total paid amount for this month
        $totalPaidThisMonth = $invoicesThisMonth->sum('amount_paid');

        // Calculate unpaid amount for this month
        $totalUnpaidThisMonth = $invoicesThisMonth->sum('total_amount') - $totalPaidThisMonth;

        // Calculate total paid amount (for all time)
        $totalPaidAllTime = Invoice::sum('amount_paid');


        return view('landlord/dashboard', compact(
            'totalPaidThisMonth',
            'totalUnpaidThisMonth',
            'totalPaidAllTime',
        )
        );
    }
    public function apartmentPayments($apartmentId)
    {
        // Retrieve the selected apartment
        $apartment = Apartments::findOrFail($apartmentId); // Assuming 'Apartments' is the correct model name

        // Retrieve invoices for this month
        $invoicesThisMonth = Invoice::whereMonth('due_date', now()->month)->get();

        // Calculate total paid amount for this month
        $totalPaidThisMonth = $invoicesThisMonth->sum('amount_paid');

        // Calculate unpaid amount for this month
        $totalUnpaidThisMonth = $invoicesThisMonth->sum('total_amount') - $totalPaidThisMonth;

        // Calculate total paid amount (for all time)
        $totalPaidAllTime = Invoice::sum('amount_paid');


        return view('landlord.apartmentdashboard', compact(
            'totalPaidThisMonth',
            'totalUnpaidThisMonth',
            'totalPaidAllTime',
        )
        );

    }

    public function index(Request $request)
    {
        $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided

        // Query invoices based on the payment_status filter
        $invoices = Invoice::when($paymentStatus !== 'all', function ($query) use ($paymentStatus) {
            return $query->where('payment_status', $paymentStatus);
        })->get();
        return view('admin.invoices.invoices', compact('invoices', 'paymentStatus'));
    }
    // Display invoices with "Paid" status
    public function showPaidInvoices()
    {
        $paidInvoices = Invoice::where('payment_status', 'Paid')->get();

        return view('landlord.invoices.paid', compact('paidInvoices'));
    }

    // Display invoices with "Unpaid" status
    public function showUnpaidInvoices()
    {
        $unpaidInvoices = Invoice::where('payment_status', 'Unpaid')->get();

        return view('landlord.invoices.unpaid', compact('unpaidInvoices'));
    }
    public function thisMonth(request $request, $apartmentId)
    {
        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
        $user = $data['user'];
        $apartment = $data['apartment'];
        $apartments = $data['apartments'];
        // Get the current year and month
        $currentYear = now()->year;
        $currentMonth = now()->month;

        // Calculate the start and end dates for the current month
        $startDate = Carbon::create($currentYear, $currentMonth, 1)->startOfMonth();
        $endDate = Carbon::create($currentYear, $currentMonth, 1)->endOfMonth();

        // Query the invoices for the current month
        $invoices = Invoice::whereBetween('due_date', [$startDate, $endDate])->get();

        return view('landlord.invoices.this-month-invoices', compact('invoices', 'apartment'));
    }
    public function thisMonthFilteredByStatus($status)
    {
        $statuses = explode(',', $status);
        // Get invoices for the current month with a specific payment status
        $invoices = Invoice::whereMonth('due_date', now()->month)
            ->whereIn('payment_status', $statuses)
            ->get();

        return view('landlord.invoices.this-month-invoices', compact('invoices'));
    }



    public function showInvoice(Invoice $invoice)
    {
        // Load the invoice items and other related data
        $invoice->load('room.users', 'room.apartments');
        $user = $invoice->room->users->first(); // Assuming one user per room
        $room = $invoice->room;
        $invoices = Invoice::all();
        // Load related partial payments for the invoice.
        $partialPayments = $invoice->payments;

        // Calculate the balance.
        $balance = $invoice->total_amount - $invoice->amount_paid;

        return view('landlord.invoices.invoice', compact('invoice', 'partialPayments', 'balance', 'user', 'room'));
    }

    public function updateInvoiceItems(Request $request, $invoiceId)
    {
        // Retrieve the invoice
        $invoice = Invoice::findOrFail($invoiceId);

        // Validate the form input
        $validatedData = $request->validate([
            'items' => 'required|array',
            'items.*.item' => 'required|string',
            'items.*.value' => 'required|string',
        ]);

        // Update the invoice items
        $invoice->invoice_items = json_encode($validatedData['items']);
        $invoice->save();
        //Session::flash('success', 'Invoice updated successfully.');

        return redirect()->route('edit-invoice', ['invoice' => $invoiceId])
            ->with('success', 'Invoice updated successfully.');

    }

    public function editInvoice(Request $request, $apartmentId, $invoiceId)
    {

        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
        $user = $data['user'];
        $apartment = $data['apartment'];
        $apartments = $data['apartments'];

        $paymentStatus = $request->input('status', 'all'); // Default to 'all' if no status is provided
        // Step 1: Check if the authenticated user is a landlord
        if (auth()->user()->hasRole('landlord')) {

            // Retrieve the selected apartment
            // $apartment = Apartments::findOrFail($apartmentId);
            // Check if the user is associated with the requested apartment
            $apartment = $user->apartments()->find($apartmentId);

            // Retrieve the list of apartments associated with the user
            $apartments = $user->apartments()->get(); // Assuming your relationship is defined correctly

            if ($apartment) {
                // Retrieve property data for the apartment
                $properties = $apartment->properties;

                //   // Retrieve invoices associated with rooms in the apartment using the pivot table
                $apartmentInvoices = Invoice::whereHas('rooms.apartments', function ($query) use ($apartment) {
                    $query->where('apartments.id', $apartment->id);
                })->get();
                $invoice = Invoice::findOrFail($invoiceId); // Retrieve the invoice by its ID.

                // Add any additional logic here if needed.
                $user = $invoice->rooms->users->first(); // Assuming one user per room
                $invoiceItems = json_decode($invoice->invoice_items, true); // Decode JSON data
                            // Render the invoice view
$invoiceView = view('landlord.invoices.invoice', compact('invoice', 'user', 'invoiceItems', 'apartment'))->render();

// Return the invoice view as a regular response
return response()->make($invoiceView);

                // ]);

                // return view('landlord.invoices.invoice', compact('invoice', 'user', 'invoiceItems', 'apartment'));




            }
        }
    }
    public function handlePayment(Request $request, $invoiceId)
    {
        // Get the invoice for which the payment is made.
        $invoice = Invoice::findOrFail($invoiceId);

        // Calculate the new total payments.
        $newPayments = $invoice->payments + $request->input('payment_amount');

        // Update the payments column in the invoice.
        $invoice->update(['payments' => $newPayments]);

        // Redirect back to the invoice page or any appropriate page.
        return redirect()->route('edit-invoice', ['invoice' => $invoiceId])
            ->with('success', 'Payment recorded successfully.');
    }





    public function addPayment(Request $request, $invoiceId)
    {
        // Start a database transaction
        DB::beginTransaction();
        try {
            // Validate the incoming request data
            $validatedData = $request->validate([
                'payment_date' => 'required|date',
                'payment_method' => 'required|string',
                'transaction_id' => 'required|string',
                'payment_amount' => 'required|numeric',
                'transaction_fee' => 'required|numeric',
            ]);

            // Find the invoice by ID
            $invoice = Invoice::find($invoiceId);

            if (!$invoice) {
                // Handle the case where the invoice is not found
                return redirect()->back()->with('error', 'Invoice not found.');
            }

            // Construct the new payment data
            $paymentData = [
                'payment_date' => $validatedData['payment_date'],
                'payment_method' => $validatedData['payment_method'],
                'transaction_id' => $validatedData['transaction_id'],
                'payment_amount' => $validatedData['payment_amount'],
                'transaction_fee' => $validatedData['transaction_fee'],
            ];

            // Retrieve the existing payments from the invoice
            $payments = json_decode($invoice->payments, true) ?? [];

            // Add the new payment to the payments array
            $payments[] = $paymentData;

            // Update the invoice with the updated payments data
            $invoice->update(['payments' => json_encode($payments)]);

            // Calculate the total amount paid
            $amountPaid = array_sum(array_column($payments, 'payment_amount'));

            // Update the invoice's "amount_paid" and "balance" columns
            $invoice->update(['amount_paid' => $amountPaid, 'balance' => $invoice->total_amount - $amountPaid]);
            // Calculate the balance.
            $balance = $invoice->total_amount - $invoice->amount_paid;

            if ($balance == 0) {
                // If the balance is zero, set the payment status to 'paid'.
                $invoice->payment_status = 'paid';
            } elseif ($balance > 0) {
                // If the balance is greater than zero, set the payment status to 'partial'.
                $invoice->payment_status = 'partial';
            } else {
                // If the balance is less than zero, set the payment status to 'unpaid' or handle this case as needed.
                $invoice->payment_status = 'unpaid';
            }

            // Save the updated payment status.
            $invoice->save();

            // Commit the transaction if everything is successful
            DB::commit();

            return redirect()->back()->with('success', 'Payment added successfully.');
        } catch (\Exception $e) {
            // Something went wrong, so roll back the transaction
            DB::rollBack();

            // Handle the exception (e.g., log or display an error message)
            return redirect()->back()->with('error', 'Error adding payment: ' . $e->getMessage());
        }
    }

    public function markStatus(Request $request, $invoiceId)
    {
        // Get the invoice for which the status is updated.
        $invoice = Invoice::findOrFail($invoiceId);

        // Validate the status input.
        $request->validate([
            'status' => 'required|in:paid,unpaid,canceled,partial',
        ]);

        // Update the status column in the invoice.
        $invoice->update(['payment_status' => $request->input('status')]);

        // Redirect back to the invoice edit page
        return redirect()->route('edit-invoice', ['invoice' => $invoiceId])
            ->with('success', 'Status updated successfully');

    }

    // public function addPayment(Request $request, $invoiceId)
    // {
    //     // Validate the payment input.
    //     $request->validate([
    //         'payment_amount' => 'required|numeric|min:0',
    //     ]);

    //     // Get the invoice for which the payment is made.
    //     $invoice = Invoice::findOrFail($invoiceId);

    //     // Calculate the new total payments.
    //     $newPayments = $invoice->payments + $request->input('payment_amount');

    //     // Update the payments column in the invoice.
    //     $invoice->update(['payments' => $newPayments]);

    //     // Redirect back to the invoice edit page with a success message.
    //     return redirect()->route('edit-invoice', ['invoice' => $invoiceId])
    //         ->with('success', 'Payment recorded successfully.');
    // }

    public function update(Request $request, $id)
    {
        //                                     $invoice = Invoice::findOrFail($id);
//                                     $invoiceItems = json_decode($invoice->invoice_items, true);

        //                                     $validatedData = $request->validate([
//                                         'invoice_items' => 'required|json',
//                                         'total_amount'=>'required|numeric|min:0',
//                                         // Other validation rules...
//                                     ]);

        //                                     // $invoice->invoice_items = $validatedData['invoice_items'];
//                                     // $invoice->total_amount = $validatedData['total_amount'];

        //                                     // // Save other fields as needed...

        //                                     // $invoice->save();
//                                     // Retrieve the updated invoice items and total amount from the request
// $updatedItems = $request->input('invoice_items');
// $totalAmount = $request->input('total_amount');

        // // Update the invoice model
// $invoice->invoice_items = json_encode($updatedItems);
// $invoice->total_amount = $totalAmount;
// $invoice->save();

        //                                     return redirect()->route('edit-invoice', $invoice->id)->with('success', 'Invoice updated successfully.');
//                                 }
        // Retrieve the updated invoice items and total amount from the request
        $updatedItems = $request->input('invoice_items');
        $totalAmount = $request->input('total_amount');

        // Find the invoice
        $invoice = Invoice::findOrFail($id);

        // Update the invoice model
        $invoice->invoice_items = json_encode($request->input('invoice_items'));
        $invoice->total_amount = $request->input('total_amount');
        $invoice->save();

        return redirect()->route('edit-invoice', $invoice->id)->with('success', 'Invoice updated successfully.');
    }


    public function deleteInvoices(Request $request)
    {
        $selectedInvoiceIds = $request->input('selectedInvoiceIds');

        if (!empty($selectedInvoiceIds)) {
            // Implement your invoice deletion logic here
            // Example:
            Invoice::whereIn('id', $selectedInvoiceIds)->delete();

            return redirect()->back()->with('success', 'Selected invoices deleted successfully.');
        } else {
            return response()->json(['error' => 'No invoice IDs provided for deletion.'], 400);
        }
    }
    public function deleteSelectedInvoices(Request $request)
    {
        try {
            $invoiceIds = $request->input('invoices', []);

            // Get authenticated user's information
            $user = Auth::user();
            $userName = $user->name;
            $userIp = $request->ip();
            $userRole = $user->role; // Replace 'role' with the actual field name in your user model

            // Assuming you have an Invoice model with a 'delete' method
            $deletedCount = Invoice::whereIn('id', $invoiceIds)->delete();

            Log::info("User {$userName} (Role: {$userRole}) with IP {$userIp} deleted {$deletedCount} invoices with IDs: " . implode(', ', $invoiceIds));

            Session()->flash('success', "Successfully deleted {$deletedCount} invoices.");
        } catch (\Exception $e) {
            // Get authenticated user's information
            $user = Auth::user();
            $userName = $user->name;
            $userIp = $request->ip();
            $userRole = $user->role; // Replace 'role' with the actual field name in your user model

            Log::error("Error deleting invoices by user {$userName} (Role: {$userRole}) with IP {$userIp}: " . $e->getMessage());
            Session()->flash('error', 'An error occurred while deleting invoices.');
        }

        return response()->json(['success' => true]);
    }

    public function showCompoundedBalancesForUsers()
    {
        // Fetch all users
        $users = User::with('invoices')->get();

        // Calculate compounded balances for each user
        foreach ($users as $user) {
            $user->compoundedBalance = $this->calculateUserCompoundedBalance($user);
        }
        //$totalcompoundedBalance=sum($compoundedBalance);
        return view('landlord.this-month-report', compact('users'));
    }

    private function calculateUserCompoundedBalance($user)
    {
        $compoundedBalance = 0;

        foreach ($user->invoices as $invoice) {
            $previousInvoices = Invoice::where('room_id', $invoice->room_id)
                ->where('due_date', '<', $invoice->due_date)
                ->orderBy('due_date', 'asc')
                ->get();

            $invoiceBalance = $invoice->balance;

            foreach ($previousInvoices as $previousInvoice) {
                $invoiceBalance += $previousInvoice->balance;
            }

            $compoundedBalance += $invoiceBalance;
        }

        return $compoundedBalance;
    }

}
