<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use Illuminate\Http\Request;

class LandlordInvoiceController extends Controller
{
    //
    public function delete(Request $request, $id)
    {
        // Handle the delete action
        $invoice = Invoice::find($id);

        if ($invoice) {
            // Delete the invoice
            $invoice->delete();

            return response()->json(['status' => 'success', 'message' => 'Invoice deleted successfully']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Invoice not found'], 404);
        }
    }

    public function update(Request $request, $id)
    {
        // Handle the update action
        $invoice = Invoice::find($id);

        if ($invoice) {
            // Update the invoice, you can customize this based on your needs
            $invoice->update([
                'status' => $request->input('status'),
                // Other fields to update
            ]);

            return response()->json(['status' => 'success', 'message' => 'Invoice updated successfully']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Invoice not found'], 404);
        }
    }
}
