<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Ticket;
use App\Models\Invoice;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\HttpClientException;


class LandlordController extends Controller
{
    //
    //
    use ApartmentLandlordViewController;
    public function dashboard()
{
    // Get the currently authenticated landlord (assuming you have authentication set up)
    $landlord = auth()->user();
    $tasks = Auth::user()->tasks;
    // Retrieve the assigned apartments for the landlord
    $apartments = $landlord->apartments;

    return view('landlord.dashboard', compact('apartments','tasks'));
}
    public function index()
    {
        $landlord = auth()->user();
        $landlordApartments = $landlord->apartments;
        $apartments = $landlord->apartments;
        // $tasks = Auth::user()->tasks()->latest()->get();

        return view('/landlord/dashboard', compact('landlordApartments', 'apartments'));
    }

    public function manage($apartmentId)
    {
        // Retrieve the selected apartment
        $apartment = Apartments::findOrFail($apartmentId); // Assuming 'Apartments' is the correct model name

        // Retrieve caretakers associated with the apartment
        $caretakers = User::whereHas('roles', function ($query) {
            $query->where('name', 'caretaker');
        })->whereHas('apartments', function ($query) use ($apartment) {
            $query->where('apartments.id', $apartment->id);
        })->get();

        // Retrieve property data for the apartment
        $properties = $apartment->properties;
        // Retrieve invoices for this month
        $invoicesThisMonth = Invoice::whereMonth('due_date', now()->month)->get();

        // Calculate total paid amount for this month
        $totalPaidThisMonth = $invoicesThisMonth->sum('amount_paid');

        // Calculate unpaid amount for this month
        $totalUnpaidThisMonth = $invoicesThisMonth->sum('total_amount') - $totalPaidThisMonth;

        // Calculate total paid amount (for all time)
        $totalPaidAllTime = Invoice::sum('amount_paid');

        return view('landlord.apartmentdashboard', compact('apartment', 'caretakers', 'properties'));
    }


public function assignCaretaker(Apartments $apartment, User $user)
{
    // Check if the user is in the specified apartment
    if ($user->apartment->id === $apartment->id) {
        // Assign the caretaker role
        $user->assignRole('caretaker', 'apartment-'.$apartment->id);
    }

    // Redirect back to the user list or another appropriate page
    return redirect()->route('usersInApartment', $apartment);
}

    public function showRoleAssignmentForm()
    {
        $users = User::all();
        return view('admin.landlords', compact('users'));
    }

    public function assignRole(Request $request)
{
    $user = User::find($request->input('user_id'));
    $role = $request->input('role');

    // Assign the selected role to the user
    $user->assignRole($role);

    return redirect()->back()->with('success', 'Role assigned successfully');
}
public function registerNewTenant(request $request, $apartment){
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];
    $apartmentId = $apartment->id;
    return view('landlord.tenants.landlord-register-tenant',compact('apartment', 'apartmentId'));
}

public function registerNewTenantProcess(request $request, $apartment){

    //dd($request->all());
    // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];
    $apartmentId = $apartment->id;


    //dd($request->all());
    // Validate the request data
    // $request->validate([
    //     'first_name' => 'required|string',
    //     'surname' => 'required|string',
    //     'last_name' => 'required|string',
    //     // 'email' => [
    //     //     'required',
    //     //     'email',
    //     //     Rule::unique('users')->where(function ($query) use ($request) {
    //     //         return $query->where('email', $request->email)
    //     //             ->orWhere('phone_number', $request->phone_number);
    //     //     }),
    //     // ],
    //     'email' => [
    //         'required',
    //         'email',
    //         Rule::unique('users'),
    //     ],
    //     'phone_number' => [
    //         'required',
    //         Rule::unique('users'),
    //     ],

    //     'password' => 'required|min:6',
    //     // 'address1' => 'required|string',
    //     // 'address2' => 'nullable|string',
    //     // 'companyName' => 'nullable|string',
    //     // 'maritalstatus' => 'required|string',
    //     // Add more validation rules as needed
    // ]);

    // // Create a new user instance
    // $user = new User();
    // $user->first_name = $request->first_name;
    // $user->name = $request->surname;
    // $user->last_name = $request->last_name;
    // $user->email = $request->email;
    // $user->phone_number = $request->phone_number;
    // $user->password = bcrypt($request->password);
    // // $user->address1 = $request->address1;
    // // $user->address2 = $request->address2;
    // // $user->company_name = $request->companyName;
    // // $user->marital_status = $request->maritalstatus;
    // // Add more user attributes as needed

// Validate the request data
$validatedData = $request->validate([
    'first_name' => 'required|string',
    'surname' => 'required|string',
    'last_name' => 'required|string',
    'email' => 'required|email|unique:users',
    'password' => 'required|min:6',
    // Add more validation rules as needed
]);

// Create a new user instance only if validation passes
if ($validatedData) {
    // Create a new user instance
    $user = new User();
    $user->fill($validatedData);
    $user->password = Hash::make($request->password); // Hash the password

    // Save the user
    if ($user->save()) {
        // Log the authenticated user
        Auth::user()->logActivity('Registered new tenant: ' . $user->first_name);

        // Redirect back or to a success page with a success message
        return redirect()->back()->with('success', 'Tenant registered successfully!');
    } else {
        // If user creation fails, redirect back with an error message
        return redirect()->back()->with('error', 'Failed to register tenant. Please try again.');
    }
} else {
    // If validation fails, redirect back with validation errors
    return redirect()->back()->withErrors($validatedData)->withInput();
}


}
}
