<?php

namespace App\Http\Controllers;

use App\Mail\WelcomeEmail;
use Illuminate\Http\Request;
use App\Services\apartmentEmail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class EmailController extends Controller
{
    //
    public function sendEmail($apartmentId)
    {
        // Define email parameters
        $to = 'recipient@example.com';
        $subject = 'Test Email';
        $body = 'This is a test email.';

        // Send email using apartment's SMTP configuration
        apartmentEmail::sendEmail($apartmentId, $to, $subject, $body);

        return 'Email sent successfully.';
    }
    public function sendWelcomeEmail(Request $request)
{
    $user = Auth::user(); // Assuming you have a logged-in user
    Mail::to($user)->send(new WelcomeEmail($user));
    return 'Welcome email sent successfully.';
}
}
