<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class CaretakerController extends Controller
{
    //
    public function index(){
        return view('/caretaker/dashboard');
    }

    public function assignCaretaker(Apartments $apartment, Request $request)
{
    // Validate the request data (e.g., ensure 'user_id' is present)
    $request->validate([
        'user_id' => 'required|exists:users,id',
    ]);

    // Get the selected user based on the user_id from the request
    $user = User::findOrFail($request->input('user_id'));

    // Assign the "Caretaker" role to the selected user
    $user->assignRole('caretaker');

    // You can also sync the user's role with the specific apartment if needed
    $user->apartments()->syncWithoutDetaching($apartment);

    // Redirect back to the apartment details page with a success message
    return redirect()->route('landlord.manage', ['apartment' => $apartment])
        ->with('success', 'Caretaker assigned successfully');
}

}
