<?php

namespace App\Http\Controllers;

use App\Models\Apartments;

use App\Models\Services;
use Illuminate\Http\Request;
use App\Models\ApartmentSetting;
use App\Http\Controllers\ApartmentLandlordViewController;

class ApartmentSettingsController extends Controller
{
     //
     use ApartmentLandlordViewController;
    public function show(request $request, $apartment){
        // Use the accessApartment method from the trait
    $data = $this->accessApartment($apartment);

    // Access the variables from the compact statement
    $user  = $data['user'];
    $apartment = $data['apartment'];
    $apartments = $data['apartments'];

    return view('landlord.apartments.settings.setup', compact('apartment','apartments'));
    }
    public function showGeneralSettings(Request $request, $apartmentId) {
        // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
        $user = $data['user'];
        $apartment = $data['apartment'];
        $apartments = $data['apartments'];

        // Fetch general settings for the apartment
        $generalSettings = ApartmentSetting::where('apartment_id', $apartment->id)
            ->where('category', 'general')
            ->get();

        // Fetch and organize the subsections for the general settings
        $subSections = $this->getSubSectionsForGeneralSettings();
           // Fetch specific settings for the apartment
    $showMonthlyPaidBalance = $this->getApartmentSetting($apartment->id, 'general', 'dashboard', 'show_monthly_paid_balance');
    $showMonthlyUnpaidBalance = $this->getApartmentSetting($apartment->id, 'general', 'dashboard', 'show_monthly_unpaid_balance');


        return view('landlord.apartments.settings.general-settings', compact('apartment', 'generalSettings', 'subSections','showMonthlyPaidBalance', 'showMonthlyUnpaidBalance'));
    }
    protected function getSubSectionsForGeneralSettings() {
        // Define your subsections as needed
        return [
            'dashboard' => 'Dashboard Settings',
            'localization' => 'Localization Settings',
            'invoices' => 'Invoice Settings',
            'social' => 'Social Settings',
            // Add more subsections as needed
        ];
    }
    protected function getApartmentSetting($apartmentId, $category, $subCategory, $settingKey) {
        return ApartmentSetting::where('apartment_id', $apartmentId)
            ->where('category', $category)
            ->where('sub_category', $subCategory)
            ->where('setting_key', $settingKey)
            ->value('setting_value');
    }

public function showServicesSettings(Request $request, $apartmentId){
    // Use the accessApartment method from the trait
        $data = $this->accessApartment($apartmentId);
        // Access the variables from the compact statement
        $user = $data['user'];
        $apartment = $data['apartment'];
        $apartments = $data['apartments'];

        $allServices=Services::all();
    return view('landlord.apartments.settings.services-settings', compact('apartment','allServices' ));
}

}
