<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ApartmentPaymentController extends Controller
{
    //
    public function handlePaymentsAction(Request $request) {
        $selectedPayments = $request->input('selected_payments', []);
        $action = $request->input('action');

        switch ($action) {
            case 'remove':
                foreach ($selectedPayments as $paymentId) {
                    // Iterate through selected payment IDs and remove them from the invoices
                    foreach ($apartmentRecentPayments as $invoice) {
                        if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                            foreach ($invoice->payments as $index => $payment) {
                                if ($payment['payment_id'] == $paymentId) {
                                    unset($invoice->payments[$index]);
                                }
                            }
                        }
                    }
                }
                // After removal, you may want to save the updated data or perform any necessary actions
                break;

                case 'edit':
                    // Assuming you have a form for editing payments with new amounts
                    foreach ($selectedPayments as $paymentId) {
                        $newAmount = $request->input("payment_$paymentId"); // Assuming input names are like "payment_paymentId"
                        // Find and update the selected payment with the new amount
                        foreach ($apartmentRecentPayments as $invoice) {
                            if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                                foreach ($invoice->payments as $index => $payment) {
                                    if ($payment['payment_id'] == $paymentId) {
                                        $invoice->payments[$index]['payment_amount'] = $newAmount;
                                    }
                                }
                            }
                        }
                    }
                    // After editing, you may want to save the updated data or perform any necessary actions
                    break;

                    case 'transfer':
                        // Assuming you have a form for selecting destination invoices
                        $destinationInvoice = $request->input('destination_invoice');
                        foreach ($selectedPayments as $paymentId) {
                            // Find the payment to be transferred
                            foreach ($apartmentRecentPayments as $invoice) {
                                if (isset($invoice->payments) && is_iterable($invoice->payments)) {
                                    foreach ($invoice->payments as $index => $payment) {
                                        if ($payment['payment_id'] == $paymentId) {
                                            // Remove the payment from the current invoice
                                            unset($invoice->payments[$index]);
                                            // Add the payment to the destination invoice
                                            foreach ($apartmentRecentPayments as $destInvoice) {
                                                if ($destInvoice->invoice_number == $destinationInvoice) {
                                                    $destInvoice->payments[] = $payment;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        // After transferring, you may want to save the updated data or perform any necessary actions
                        break;
            default:
                // Handle invalid action
                break;
        }

        // Redirect or return response as needed
    }

}
