<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;

trait ApartmentLandlordViewController
{
    public function accessApartment($apartmentId)
    {
        // Check if the user is authenticated
        if (!Auth::check()) {
            // Handle the case when the user is not authenticated, for example, redirect to login
            return redirect()->route('login');
        }

        // Retrieve the authenticated user
        $user = Auth::user();

        // Check if the user is associated with the requested apartment
        $apartment = $user->apartments()->find($apartmentId);

        // Retrieve the list of apartments associated with the user
        $apartments = $user->apartments()->get(); // Assuming your relationship is defined correctly

        // Return the variables in an associative array
        return [
            'user' => $user,
            'apartment' => $apartment,
            'apartments' => $apartments,
        ];
    }
}
