<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use App\Models\License;
use App\Models\Apartments;
use Illuminate\Http\Request;
use App\Models\LicensePurchase;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\ApartmentLandlordViewController;

class ApartmentController extends Controller
{
    //
    use ApartmentLandlordViewController;
    public function show($apartmentId)
    {
         // Use the accessApartment method from the trait
         $data = $this->accessApartment($apartmentId);
          // Access the variables from the compact statement
        $user = $data['user'];
        $apartment = $data['apartment'];
        $apartments = $data['apartments'];
        // $this->authorize('view', $apartment);

        // $caretakers = User::role('caretaker')
        // ->whereExists(function ($query) use ($apartment) {
        //     $query->from('user_apartment')
        //           ->whereColumn('users.id', 'user_apartment.user_id');
        // })
        // ->whereExists(function ($query) use ($apartment) {
        //     $query->from('apartments')
        //           ->whereColumn('users.id', 'apartments.id')
        //           ->where('apartments.id', $apartment->id);
        // })
        // ->get();
        $apartmentLinks = [];

        foreach ($apartments as $apartment) {
            $url = $this->generateApartmentUrl($apartment->id);
            $apartmentLinks[] = [
                'apartment_name' => $apartment->name,
                'url' => $url,
            ];
        }

// Retrieve users in the apartment with the role "caretaker"
$caretakers = $apartment->users()
    ->wherePivot('role', 'caretaker')
    ->get();

        //total rooms
        $totalRooms = $apartment->getTotalRooms();
        //total users
        $usersInApartment = $apartment->users()->get();
        $totalUsersCount = $apartment->users->count();
        // Calculate the count of roles for each user


        // Retrieve property data for the apartment
        $properties = $apartment->properties;
         // Retrieve caretakers associated with the apartment
         $caretakers = User::whereHas('roles', function ($query) {
            $query->where('name', 'caretaker');
        })->whereHas('apartments', function ($query) use ($apartment) {
            $query->where('apartments.id', $apartment->id);
        })->get();

        // Retrieve property data for the apartment
        $properties = $apartment->properties;

    //    Retrieve invoices associated with rooms in the apartment using the pivot table
     $apartmentInvoices = Invoice::whereHas('rooms', function ($query) use ($apartment) {
        $query->whereHas('apartments', function ($subQuery) use ($apartment) {
            $subQuery->where('apartments.id', $apartment->id);
        });
    })->get();

$currentDate = now()->format('Y-m-d H:i:s');

// });
$currentMonthStart = now()->startOfMonth();
$currentMonthEnd = now()->endOfMonth();

$filteredInvoices = $apartmentInvoices
    ->whereBetween('due_date', [$currentMonthStart, $currentMonthEnd]);
//dd($filteredInvoices);
// Calculate total paid amount for the current month, including invoices with status 'paid' and 'partial'
//$totalPaidThisMonth = $filteredInvoices->whereIn('payment_status', ['paid', 'partial'])->sum('amount_paid');
$totalPaidThisMonth = $filteredInvoices->sum('amount_paid');


$filteredInvoicesBalances = $filteredInvoices
    ->where('balance', '>', 0);


$thisMonthOutstandingBalances = $filteredInvoicesBalances->load('user', 'rooms');

// $unpaidInvoices = $apartmentInvoices->where('payment_status', 'unpaid')->filter(function ($invoice) use ($currentMonth) {
//     return optional($invoice->due_date)->format('m') == $currentMonth;
// });
$totalUnpaidThisMonth = $filteredInvoices->sum('balance');
// Calculate total unpaid balances for the current month
$totalMonthBalances = $filteredInvoices->sum('balance');

//dd($totalUnpaidThisMonth);
// Calculate total paid amount (for all time)
$totalPaidAllTime = $apartmentInvoices->sum('amount_paid');

// Calculate payment percentage based on totalPaidThisMonth from apartmentInvoices for the month
$totalInvoiceAmountThisMonth = $filteredInvoices->where('status', '!=', 'canceled')->sum('total_amount');

//Check for division by zero
$percentagePaid = ($totalInvoiceAmountThisMonth != 0) ? ($totalPaidThisMonth / $totalInvoiceAmountThisMonth) * 100 : 0;

// Retrieve recent payments with related user information
$recentPayments = Invoice::with('user')
    ->whereNotNull('payments') // Filter out invoices with null payments
    ->orderBy('due_date', 'desc')
    ->take(10)
    ->get();

// Decode the JSON-encoded payments and order them by the maximum payment date
$recentPayments->transform(function ($invoice) {
    $invoice->payments = json_decode($invoice->payments, true);

    // Find the maximum payment date within the payments array
    $maxPaymentDate = collect($invoice->payments)->max('payment_date');

    // Add a new attribute to the invoice for sorting
    $invoice->max_payment_date = $maxPaymentDate;

    return $invoice;
});
$overallOutstandingBalances= $apartmentInvoices->where('balance', '>', 0);

$overallTotalBalance = $overallOutstandingBalances->sum('balance');
// Order the invoices by the maximum payment date
$recentPayments = $recentPayments->sortByDesc('max_payment_date');


       //dd($apartmentInvoices) ;
       //dd($recentPayments) ;
       //dd($totalPaidThisMonth);
       //dd($paidInvoices);
       //dd($unpaidInvoices) ;
       //dd($filteredInvoices);
       //dd($currentMonth, $apartmentInvoices);
        //dd($paidInvoices);
        //dd($apartmentInvoices->pluck('due_date')->toArray());
        // $url = URL::signedRoute('landlord.apartment-dashboard', ['apartment' => $apartmentId]);
        // info('Generated URL for apartment ID ' . $apartmentId . ': ' . $url);


        return view('landlord.apartmentdashboard', compact('apartment', 'apartments','caretakers',
        'properties', 'totalRooms', 'usersInApartment','apartmentInvoices',
         'totalUsersCount','totalPaidThisMonth', 'filteredInvoices', 'thisMonthOutstandingBalances','overallOutstandingBalances',
        'totalUnpaidThisMonth','percentagePaid','recentPayments','overallTotalBalance',
        'totalPaidAllTime','apartmentLinks'));
}
protected function generateApartmentUrl($apartmentId)
{
    $url = URL::signedRoute('landlord.apartment-dashboard', ['apartment' => $apartmentId]);
    info($url);
    return $url;
}
    public function apartmentRooms($apartmentId){
        $apartment= Apartments::findOrFail($apartmentId);
        $totalRooms = $apartment->getTotalRooms();

        return view('landlord.apartments.rooms', compact('apartment','totalRooms'));
    }

    public function showMyApartments(){

        // Retrieve the authenticated user
    $user = Auth::user();

    // Get the apartments owned by the user
    $ownedApartments = $user->ownedApartments;
        return view('landlord.apartments.apartments', compact('ownedApartments'));

    }
    public function showToDoList(){

        // Retrieve the authenticated user
    $user = Auth::user();

    // Get the apartments owned by the user
    $ownedApartments = $user->ownedApartments;
        return view('landlord.apartments.apartments', compact('ownedApartments'));

    }
    public function createApartment()
{
    $user = Auth::user();
    $userId = auth()->id();
    $userRoles = auth()->user()->roles()->pluck('name')->toArray();

    // Log the user ID, roles, and IP address for tracing redirections
    \Log::info("User ID: $userId, Roles: " . implode(', ', $userRoles) . ", IP Address: " . request()->ip());

   // Check if the user is a landlord
if ($user->isLandlord()) {
    // Check if the landlord has a valid license
    $license = LicensePurchase::where('user_id', $user->id)->first();

    if ($license && $license->isValid()) {
        // Check if the license allows creating an apartment
        if ($license->allowsApartmentCreation()) {
            // Create a new apartment with the associated license
            return redirect()->route('apartments.createForm')->with('success', 'You can create an Apartment!');
        } else {
            return redirect()->back()->with('error', 'Your license does not allow creating more apartments.');
        }
    } else {
        // Redirect to the upgrading page if the license is invalid
        return redirect()->route('licenses.upgrade-page')->with('error', 'You do not have a valid license. Upgrade your license.');
    }
} else {
    return redirect()->route('landlord-home')->with('error', 'You do not have permission to create apartments.');
}
}


public function showCreateApartmentForm(){
    return view('landlord.apartments.create');
}
public function create(Request $request)
{
    // Validate your form data

    // Create a new apartment
    $apartment = new Apartments([
        // Fill in the necessary fields from the form request
    ]);

    // Save the apartment
    $apartment->save();

    // Retrieve the user ID and license associated with the current user
    $userId = auth()->id();
    $license = License::where('user_id', $userId)->first();

    // Attach the apartment to the license
    $license->apartments()->save($apartment);

    // Attach the apartment to the user
    $user = User::find($userId);
    $user->apartments()->save($apartment);

    return redirect()->route('apartments.createForm')->with('success', 'Apartment created successfully!');
}

    // public function createApartment()
    // {
    //     $userId = auth()->id();

    // if (auth()->check() && $this->isLandlord($userId)) {
    //     $license = License::where('user_id', $userId)->first();

    //     if ($license && $license->isValid() && $license->allowsApartmentCreation()) {
    //         $remainingApartments = $license->remainingApartments();

    //         if ($remainingApartments > 0) {
    //             // Allow creating an apartment
    //             return view('apartments.create');
    //         } else {
    //             // Redirect back with an error if the license has no remaining apartments
    //             return redirect()->back()->with('error', 'Your license does not support creating more apartments.');
    //         }
    //     } else {
    //         // Redirect back with an error if the license is not valid or doesn't allow apartment creation
    //         return redirect()->back()->with('error', 'Your license does not allow apartment creation.');
    //     }
    // } else {
    //     // Redirect non-landlords home
    //     return redirect()->route('home')->with('error', 'You do not have permission to create apartments.');
    // }
    // }


    /**
     * Check if the user is a landlord.
     *
     * @param  int  $userId
     * @return bool
     */
    private function isLandlord($userId)
    {
        // Your logic to check if the user is a landlord
        // Example: Assuming there is a 'role' field in the user model, where 'landlord' is one of the roles
        $user = User::find($userId);
        return $user && $user->role === 'landlord';
    }


private function checkLicense()
{
    // Implement your license checking logic here
    // Example: return License::isValid();
    // You may need to implement a License model or service
}
public function storeApartment(Request $request)
{
    // Validate the form data
    $request->validate([
        'apartment_name' => 'required|string|max:255',
        // Add validation rules for other fields
    ]);

    // Create a new apartment in the database
    $apartment = new Apartments();
    $apartment->name = $request->input('apartment_name');
    // Set other fields as needed
    $apartment->status = 'pending'; // You can set it to 'active' if you want it to be active immediately
    $apartment->save();

    return redirect()->route('dashboard')->with('success', 'Apartment created successfully.');
}
public function getApartmentsWithRooms(){
      // Retrieve apartments with their associated rooms
      $apartments = Apartments::with('rooms')->get();

      // Return JSON response with apartments data
      return response()->json(['apartments' => $apartments], 200);
  }

}
