<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Rooms;
use App\Models\County;
use App\Models\Landlord;
use App\Models\Apartments;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Validator;

class ApartmentAssignmentController extends Controller
{
//     //
//     public function apartmentassign(){
//     // Assign room 1 to apartment 1 with room number and apartment name
//     $apartment = Apartments::find(1);
//     $room = Rooms::find(1);
//     $apartment->rooms()->attach($room, ['room_number' => '101', 'apartment_name' => 'Apt A']);

//     // Access room numbers and apartment names
//     foreach ($apartment->rooms as $room) {
//         echo "Apartment Name: " . $room->pivot->apartment_name . ", Room Number: " . $room->pivot->room_number;
//     }
// }
public function showAllapartments(){
    $apartments=Apartments::all();
    return view('admin/apartments', compact('apartments'));
}
public function showAllApartmentsWithCounty(){
     // Eager load the 'county' relationship
     $apartments = Apartments::with('county')->get();

    // Retrieve the counties from the database
    $counties = County::all();

    return view('admin/apartmentsWithCounty', compact('apartments', 'counties'));
}
public function showApartments(){
    $landlord = auth()->user(); // Assuming you have a 'landlord' role
    $apartments = $landlord->apartments; // Assumes you have a relationship set up in your User model

    return view('landlord/apartments', compact('apartments'));

}
public function apartmentassign(Request $request){
            $validatedData = $request->validate([
                'room_id' => 'required|exists:rooms,id',
                'apartment_id' => 'required|exists:apartments,id',
            ]);

            $room = Rooms::find($validatedData['room_id']);
            $apartment = Apartments::find($validatedData['apartment_id']);

            // Get the apartment name and room number
            $apartmentName = $apartment->name;
            $roomNumber = $room->room_number;

            // Attach the room to the apartment with apartment_name and room_number
            $apartment->rooms()->attach($room, ['apartment_name' => $apartmentName, 'room_number' => $roomNumber]);


            return redirect()->back()->with('success', 'Room assigned to apartment successfully');

        }


        public function showAssignRoomToApartmentForm()
                {
                    $rooms = Rooms::all();
                    $apartments = Apartments::all();

                    return view('admin.rooms', compact('rooms', 'apartments'));
                }

                    public function showAssignmentForm()
                {
                    $landlords = User::role('landlord')->get();
                    $apartments = Apartments::all();
                                       //$landlords = Landlord::pluck('name', 'id');

                    return view('admin.apartments', compact('landlords','apartments'));
                }


                public function assignLandlord(Request $request)
                {

        // $validator = Validator::make($request->all(), [
        //     'user_id' => 'required|exists:users,id',
        //     'apartment_id' => 'required|exists:apartments,id',
        //     // 'role' => 'required|in:landlord', // Define the allowed roles
        // ]);

        // if ($validator->fails()) {
        //     return redirect()->route('allApartments')->withErrors($validator)->withInput();
        // }

        // $user = User::find($request->user_id);
        // $apartment = Apartments::find($request->apartment_id);

        // // Assign the role to the user for the specific apartment
        // $user->assignRole($request->role, 'apartment-'.$apartment->id);
        $data = $request->validate([
            'apartment_id' => 'required|exists:apartments,id',
            'landlord_id' => 'required|exists:users,id',
        ]);

        $apartment = Apartments::find($data['apartment_id']);
        $landlord = User::find($data['landlord_id']);

        // Assign the selected landlord to the apartment
        $apartment->landlords()->attach($landlord, ['role' => 'landlord', 'apartment_id' => $apartment->id]);


        // Redirect or show a success message
        return redirect()->back()->with('success', 'Landlord assigned to apartment successfully');

                }

                public function store(Request $request)
                {
                    dd($request->all());
                    $data = $request->validate([
                        'user_id' => 'required',
                        'apartment_id' => 'required',
                    ]);

                    $user = User::find($data['user_id']);
                    $apartment = Apartments::find($data['apartment_id']);

                    // Attach the user to the apartment with the specified role
                    $apartment->users()->attach($user, ['role' => 'landlord']);

                    return redirect()->back()->with('success', 'Landlord assigned to apartment successfully');
                }
  public function index()
{
    $users = User::all();
    $apartments = Apartments::all();
    return view('admin.users', compact('users', 'apartments'));
}

public function storeUser(Request $request)
{
    $request->validate([
        'user_id' => 'required|exists:users,id',
        'apartment_id' => 'required|exists:apartments,id',
    ]);

    $user = User::find($request->input('user_id'));
    $user->apartments()->attach($request->input('apartment_id'));

    return redirect()->route('assign.apartment')->with('success', 'Apartment assigned successfully');
}
}
