<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Rooms;
use App\Models\Ticket;
use App\Models\Invoice;
use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class AdminController extends Controller
{
    //
    public function login(Request $request)
{
    // Extract the adminToken from the request
    $adminToken = $request->input('adminToken');

    // Check if the adminToken is valid (you may use a database or any other validation method)
    if ($adminToken === '5FD924625F6AB16A19CC9807C7C506AE18') {
        // Admin authentication successful
        // You can perform further actions or return a view
        return view('admin/dashboard');
    } else {
        // Invalid adminToken, show an error message or redirect
        return view('admin/login')->with('error', 'Invalid adminToken');
    }
}
    public function index()
{
    $openTicketCount = Ticket::where('status', 'open')->count();
    $onlineAdmins = User::where('is_admin', 1)
    ->where('is_online', true)
        ->select('name', 'avatar', 'updated_at')
        ->get();

    return view('admin/dashboard', compact('onlineAdmins' ,'openTicketCount', )); // Return the admin home view
}
public function adminDashboard()
{
    // Retrieve the count of open tickets
    $openTicketCount = Ticket::where('status', 'open')->count();

    // Retrieve the amount paid this month
    $currentMonth = Carbon::now()->format('Y-m');
    $amountPaidThisMonth = Invoice::where('due_date', 'like', $currentMonth . '%')->sum('amount_paid');

     // Retrieve the total amount for this month (including both paid and unpaid)
     $totalAmountThisMonth = Invoice::where('due_date', 'like', $currentMonth . '%')->sum('total_amount');

     // Calculate the amount unpaid this month
     $amountUnpaidThisMonth = $totalAmountThisMonth - $amountPaidThisMonth;

     // Calculate the percentage paid
     if($totalAmountThisMonth !=0){
     $percentagePaid = ($amountPaidThisMonth / $totalAmountThisMonth) * 100;
     }else{
        $percentagePaid = 0;
     }
    // Retrieve the count of rooms occupied (assuming you have a RoomOccupancy model)
    $roomsOccupiedCount = Rooms::where('status', 'occupied', Carbon::today())->count();

    // Other data and logic for your admin dashboard

    return view('admin.dashboard', compact('openTicketCount', 'amountPaidThisMonth', 'amountUnpaidThisMonth', 'roomsOccupiedCount', 'percentagePaid'));
}

}
