<?
namespace App\Helpers;

// app/Helpers/JsonTableHelper.php

if (!function_exists('generateTableFromJson')) {
    function generateTableFromJson($jsonData)
    {
        if (!$jsonData) {
            return ''; // Return an empty string if no data is provided.
        }

        $data = json_decode($jsonData, true);

        if (!is_array($data)) {
            return ''; // Return an empty string if the JSON is invalid.
        }

        $table = '<table class="table">';

        foreach ($data as $item) {
            if (isset($item['item']) && isset($item['value'])) {
                $table .= '<tr><td>' . $item['item'] . '</td><td>' . $item['value'] . '</td></tr>';
            }
        }

        $table .= '</table>';

        return $table;
    }
}
