<?php

namespace App\Events;

use App\Models\User;
use App\Models\Rooms;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class UserAssignedToRoom
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public $user;
    public $room;

    public function __construct(User $user, Rooms $room)
    {
        $this->user = $user;
        $this->room = $room;
    }
    public function broadcastOn()
    {
        return new PrivateChannel('channel-name');
    }
}
