<?php

namespace App\Console\Commands;


use App\Models\Apartments;
use App\Models\Rooms;
use App\Models\Invoice;
use Illuminate\Console\Command;
use Carbon\Carbon;


class GenerateMonthlyInvoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoices:generate {--apartment=}';


    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate invoices for the application';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $apartmentId = $this->option('apartment');

// Fetch all occupied rooms
$occupiedRooms = Rooms::has('users')->get();

// Define the current date and time for invoice generation
$invoiceDate = now();

// Initialize an array to store invoices
$invoices = [];

foreach ($occupiedRooms as $room) {
    // Clone the $invoiceDate for each invoice
    $invoiceDateClone = clone $invoiceDate;
    // Calculate the invoice amount based on room price and other factors
    $roomPrice = $room->price;
    $additionalCharges = 0; // Additional charges if any
    $discount = 0; // Discount if any

    $calculatedAmount = $roomPrice + $additionalCharges - $discount;

    // Get the apartment name from the relationship
    $apartmentName = $room->apartments->first()->pivot->apartment_name;

    // Extract the unique initials from the apartment name
    $apartmentInitials = strtoupper(implode('', array_map('ucfirst', explode(' ', $apartmentName))));

    // Generate a unique invoice number using apartment initials
    $latestInvoice = Invoice::orderBy('id', 'desc')->first();
    $latestInvoiceNumber = $latestInvoice ? intval(substr($latestInvoice->invoice_number, strlen($apartmentInitials))) : 0;
    $invoiceNumber = $apartmentInitials . ($latestInvoiceNumber + 1);

    // ...
    // Construct the invoice items array
    $invoiceItems = [
        [
            'item' => 'Room Number',
            'value' => $room->room_number,
        ],
        [
            'item' => 'Month',
            'value' => date('F Y'), // Assuming you want the current month
        ],
        [
            'item' => 'Apartment Name',
            'value' => $apartmentName,
        ],
    ];

    // Create an instance of the Invoice model
    $invoice = new Invoice();
    $invoice->room_id = $room->id;
    $invoice->user_id = $room->users->first()->id; // Assuming one user per room
    $invoice->total_amount = $calculatedAmount;
    $invoice->invoice_number = $invoiceNumber; // Assign the generated invoice number
    $invoice->invoice_items = json_encode($invoiceItems); // Store items as JSON
    //$invoice->due_date = $invoiceDate->addDays(30); // Set the due date (e.g., 30 days from now)
    // Set the due date for this invoice (30 days from its creation date)
    $invoice->due_date = $invoiceDateClone->addDays(10);
    // Save the invoice to the database
    $invoice->save();

    // Add the generated invoice to the invoices array
    $invoices[] = $invoice;


    $this->info('Apartment Monthly invoices generated successfully.');
    // return response()->json(['success' => true, 'message' => 'Apartment Monthly invoices generated successfully.']);
}
return 0; // Add this line
}
}
