<?php

namespace App\Console\Commands;

use App\Models\Invoice;
use App\Models\Apartments;
use Illuminate\Console\Command;

class GenerateApartmentExpensesInvoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoices:generate-apartment-expenses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate invoices for apartment expenses';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

            // Fetch all apartments
            $apartments = Apartments::all();

            foreach ($apartments as $apartment) {
                // Fetch expenses for the apartment
                $expenses = $apartment->expenses;

                // Calculate total expense amount
                $totalExpenseAmount = $expenses->sum('amount');

                // Generate invoice name based on apartment settings
                $invoiceName = $this->generateInvoiceName($apartment, $totalExpenseAmount);

                // Create invoice instance
                $invoice = new Invoice();
                $invoice->apartment_id = $apartment->id;
                $invoice->total_amount = $totalExpenseAmount;
                $invoice->invoice_number = $invoiceName;

                // Associate invoice with user (if applicable)
                $invoice->user_id = $this->getUserIdForExpense($expenses);

                // Save the invoice
                $invoice->save();
            }
        }
    /**
     * Generate a unique invoice number.
     *
     * @return string
     */
    protected function generateInvoiceNumber()
    {
        // Your logic to generate a unique invoice number here
    }
    protected function generateInvoiceName($apartment, $totalExpenseAmount)
{
    // Get the abbreviation for the apartment from settings
    $abbreviation = $apartment->abbreviation;

    // Get the current month and year
    $month = now()->format('F'); // Full month name
    $year = now()->format('Y');

    // Concatenate the components to generate the invoice name
    $invoiceName = $abbreviation . '_Expenses_' . $month . '_' . $year . '_' . $totalExpenseAmount;

    return $invoiceName;
}

protected function getUserIdForExpense($expenses)
{
    foreach ($expenses as $expense) {
        // Check if the expense is associated with a user
        if ($expense->user_id) {
            return $expense->user_id;
        }
    }

    // If no user is associated with any of the expenses, return null
    return null;
}

}
